{
 -------------------------------------------------------------------------
 Copyright (C) 1998-2003 Hger+Busch                   / >>>>>>>>> /-----
 Ingenieurbuero fuer Kommunikationslsungen           / <<<<<<<<< /
 ----------------------------------------------------/ >>>>>>>>> /
 All rights reserved.
                                                    http://www.commso.com

 Project     : hbTapi Components
 Modul       : CallerID Sample v1.1

 Description : This sample shows how to detect a Caller's ID (phone number).

 History     : [-] Fixed [+] Added [*] Improved

 01/01/03   Creation
}
unit uMain;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Tapi, ExtCtrls, hbTAPI;

type
  TForm1 = class(TForm)
    LabelCallerIDName: TLabel;
    EditCallerIDName: TEdit;
    LabelCallerIDNumber: TLabel;
    EditCallerIDNumber: TEdit;
    LabelDevice: TLabel;
    ComboBoxDevice: TComboBox;
    TapiLine1: TTapiLine;
    EditInfo: TEdit;
    Label1: TLabel;
    procedure FormCreate(Sender: TObject);
    procedure ComboBoxDeviceChange(Sender: TObject);
    procedure TapiLine1CallerID(Sender: TTapiLine; Call: TTapiCall);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  // Fill in the ComboBox with all available telephony line devices
  ComboBoxDevice.Items.Assign(TapiLine1.DeviceList);
  if ComboBoxDevice.Items.Count > 0 then
    ComboBoxDevice.Items.Insert(0, '- none -')
  else
    ComboBoxDevice.Items.Add('- none -');

  ComboBoxDevice.ItemIndex := 0;
end;

procedure TForm1.ComboBoxDeviceChange(Sender: TObject);
begin
  // If TapiLine is currently open then close it
  TapiLine1.Active := False;

  // Set the TapiLine.DeviceID to use the device selected in the list box
  TapiLine1.DeviceID := ComboBoxDevice.ItemIndex-1;

  // If there was a problem opening TapiLine last time then make sure that the
  // following properties are reset to their default.
  TapiLine1.Privileges.Monitor := TRUE;
  TapiLine1.Privileges.Owner   := TRUE;

  try
    TapiLine1.Active := True;
  except
    on E:ETapiError do
      case E.ErrorCode of
         LINEERR_INVALMEDIAMODE :
         begin
           try
             TapiLine1.Privileges.Owner := FALSE;
             TapiLine1.Active := True;
           except
             on E:Exception do
               MessageDlg('Error opening line device: ' + E.Message, mtError, [mbOk],0);
           end;
           MessageDlg('This device is not 100% TAPI compliant',mtWarning, [mbOk],0);
         end;
      else  // Time for a little error checking
        MessageDlg('Error opening line device: ' + E.Message, mtError, [mbOk],0);
      end;
  end;
end;

procedure TForm1.TapiLine1CallerID(Sender: TTapiLine; Call: TTapiCall);
begin
  // When this event is fired the CallerID information has changed
  // or become availabe
  EditCallerIDName.Text   := '';
  EditCallerIDNumber.Text := '';

  // Copy the values to the controls
  if Call.CallerID.NameAvail then
    EditCallerIDName.Text := Call.CallerID.Name;
  if Call.CallerID.AddressAvail then
    EditCallerIDNumber.Text := Call.CallerID.Address;

  // Check a few of the TapiLine.CallerID Flags
  if Call.CallerID.Blocked then
    EditInfo.Text := 'Blocked';
  if Call.CallerID.OutOfArea then
    EditInfo.Text := 'Out of area';
end;

end.
